package gov.va.vinci.dart.db;

import java.util.Date;
import java.util.List;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.biz.DartRequest;
import gov.va.vinci.dart.biz.Participant;
import gov.va.vinci.dart.biz.Person;
import gov.va.vinci.dart.biz.Request;
import gov.va.vinci.dart.biz.RequestLocationDocumentSummary;
import gov.va.vinci.dart.biz.RequestParticipantDocumentSummary;
import gov.va.vinci.dart.biz.RequestSummary;
import gov.va.vinci.dart.biz.ResearchStudy;
import gov.va.vinci.dart.service.DartObjectFactory;

public class TestRequestDAO extends BusinessIntegrationTest {

	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}
	
	@Test
	public void testOne() throws Exception {
		Person pers = DartObjectFactory.getInstance().getPersonDAO().findById(1006);
		Assert.assertNotNull(pers);
		Assert.assertTrue(pers.getId() > 0);

		ResearchStudy activity = DartObjectFactory.getInstance().getResearchStudyDAO().findById(1);
		Assert.assertNotNull(activity);
		Assert.assertTrue(activity.getId() > 0);
		
		// create request 1 so we'll have something to work with
		DartRequest req = DartRequest.create("test request 1", new Date(), new Date(), pers, activity, "DNS");

		Assert.assertNotNull(req);
		Assert.assertTrue(req.getId() > 0);
		
		Request req2 = DartObjectFactory.getInstance().getRequestDAO().findById(req.getId());
		Assert.assertNotNull(req2);
		Assert.assertEquals(req2, req);
		
		int amendmentCount = DartObjectFactory.getInstance().getRequestDAO().countRequestAmendments(req.getId());
		Assert.assertEquals(amendmentCount, 0);

		int monthCount = DartObjectFactory.getInstance().getRequestDAO().countRequestsInMonth();
		Assert.assertTrue(monthCount > 0);
	}
	
	@Test
	public void testTwo() throws Exception {
		Person pers = DartObjectFactory.getInstance().getPersonDAO().findById(1006);
		Assert.assertNotNull(pers);
		Assert.assertTrue(pers.getId() > 0);

		ResearchStudy activity = DartObjectFactory.getInstance().getResearchStudyDAO().findById(1);
		Assert.assertNotNull(activity);
		Assert.assertTrue(activity.getId() > 0);
		
		// create request 1 so we'll have something to work with
		DartRequest req = DartRequest.create("test request 2", new Date(), new Date(), pers, activity, "DNS");

		Assert.assertNotNull(req);
		Assert.assertTrue(req.getId() > 0);
		
		// add a participant to the request
		Participant participant = Participant.create(pers, req, pers.getLocation(), true, true, true);
		req.getParticipants().add(participant);
		
		Request req2 = DartObjectFactory.getInstance().getRequestDAO().findById(req.getId());
		Assert.assertNotNull(req2);
		Assert.assertEquals(req2, req);
		
		String trackingNumber = req.getTrackingNumber();
		Assert.assertNotNull(trackingNumber);
		Assert.assertTrue(trackingNumber.length() > 0);
		
		List<RequestSummary> rList = DartObjectFactory.getInstance().getRequestDAO().listByTrackingNumber(trackingNumber);
		Assert.assertNotNull(rList);
		Assert.assertTrue(rList.size() > 0);

		rList = DartObjectFactory.getInstance().getRequestDAO().listAllRequestSummary();
		Assert.assertNotNull(rList);
		Assert.assertTrue(rList.size() > 0);

		rList = DartObjectFactory.getInstance().getRequestDAO().listAllRequestSummaryWithoutContactName();
		Assert.assertNotNull(rList);
		Assert.assertTrue(rList.size() > 0);

		rList = DartObjectFactory.getInstance().getRequestDAO().listAllButInitiated();
		Assert.assertNotNull(rList);
		Assert.assertTrue(rList.size() > 0);

		rList = DartObjectFactory.getInstance().getRequestDAO().listAllButInitiatedWithoutContactName();
		Assert.assertNotNull(rList);
		Assert.assertTrue(rList.size() > 0);

		rList = DartObjectFactory.getInstance().getRequestDAO().listAllUserReviewable(pers.getId());
		Assert.assertNotNull(rList);

		Assert.assertNotNull(pers.getGroups());
		Assert.assertTrue(pers.getGroups().size() > 0);
		
		rList = DartObjectFactory.getInstance().getRequestDAO().listAllGroupReviewable(pers.getGroups().iterator().next().getName());
		Assert.assertNotNull(rList);

		List<RequestLocationDocumentSummary> rldsList = DartObjectFactory.getInstance().getRequestDAO().listRequestLocationDocumentSummaryByReviewer(req.getId(), pers.getName());
		Assert.assertNotNull(rldsList);

		List<RequestParticipantDocumentSummary> rpdsList = DartObjectFactory.getInstance().getRequestDAO().listRequestParticipantDocumentSummaryByReviewer(req.getId(), pers.getName());
		Assert.assertNotNull(rpdsList);

	}
}
